/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.simibubi.create.AllPackets;
import com.simibubi.create.content.logistics.filter.AttributeFilterScreen;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import com.simibubi.create.foundation.gui.menu.GhostItemSubmitPacket;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GhostIngredientHandler<T extends GhostItemMenu<?>>
implements IGhostIngredientHandler<AbstractSimiContainerScreen<T>> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AbstractSimiContainerScreen<T> gui, ITypedIngredient<I> ingredient, boolean doStart) {
        boolean isAttributeFilter = gui instanceof AttributeFilterScreen;
        LinkedList<IGhostIngredientHandler.Target<I>> targets = new LinkedList<IGhostIngredientHandler.Target<I>>();
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            for (int i = 36; i < ((GhostItemMenu)gui.m_6262_()).f_38839_.size(); ++i) {
                if (((Slot)((GhostItemMenu)gui.m_6262_()).f_38839_.get(i)).m_6659_()) {
                    targets.add(new GhostTarget(gui, i - 36, isAttributeFilter));
                }
                if (isAttributeFilter) break;
            }
        }
        return targets;
    }

    public void onComplete() {
    }

    public boolean shouldHighlightTargets() {
        return true;
    }

    private static class GhostTarget<I, T extends GhostItemMenu<?>>
    implements IGhostIngredientHandler.Target<I> {
        private final Rect2i area;
        private final AbstractSimiContainerScreen<T> gui;
        private final int slotIndex;
        private final boolean isAttributeFilter;

        public GhostTarget(AbstractSimiContainerScreen<T> gui, int slotIndex, boolean isAttributeFilter) {
            this.gui = gui;
            this.slotIndex = slotIndex;
            this.isAttributeFilter = isAttributeFilter;
            Slot slot = (Slot)((GhostItemMenu)gui.m_6262_()).f_38839_.get(slotIndex + 36);
            this.area = new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 16, 16);
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            ItemStack stack = ((ItemStack)ingredient).m_41777_();
            stack.m_41764_(1);
            ((GhostItemMenu)this.gui.m_6262_()).ghostInventory.setStackInSlot(this.slotIndex, stack);
            if (this.isAttributeFilter) {
                return;
            }
            AllPackets.getChannel().sendToServer((Object)new GhostItemSubmitPacket(stack, this.slotIndex));
        }
    }
}

