/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.utility.RaycastHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ValueSettingsInputHandler {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (!ValueSettingsInputHandler.canInteract(player)) {
            return;
        }
        if (AllBlocks.CLIPBOARD.isIn(player.m_21205_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity sbe = (SmartBlockEntity)blockEntity;
        if (event.getSide() == LogicalSide.CLIENT) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateClient.VALUE_SETTINGS_HANDLER.cancelIfWarmupAlreadyStarted(event));
        }
        if (event.isCanceled()) {
            return;
        }
        for (BlockEntityBehaviour behaviour : sbe.getAllBehaviours()) {
            if (!(behaviour instanceof ValueSettingsBehaviour)) continue;
            ValueSettingsBehaviour valueSettingsBehaviour = (ValueSettingsBehaviour)((Object)behaviour);
            BlockHitResult ray = RaycastHelper.rayTraceRange(world, player, 10.0);
            if (ray == null) {
                return;
            }
            if (behaviour instanceof SidedFilteringBehaviour && (behaviour = ((SidedFilteringBehaviour)behaviour).get(ray.m_82434_())) == null || !valueSettingsBehaviour.isActive() || valueSettingsBehaviour.onlyVisibleWithWrench() && !AllTags.AllItemTags.WRENCH.matches(player.m_21120_(hand))) continue;
            ValueBoxTransform valueBoxTransform = valueSettingsBehaviour.getSlotPositioning();
            if (valueBoxTransform instanceof ValueBoxTransform.Sided) {
                ValueBoxTransform.Sided sidedSlot = (ValueBoxTransform.Sided)valueBoxTransform;
                if (!sidedSlot.isSideActive(sbe.m_58900_(), ray.m_82434_())) continue;
                sidedSlot.fromSide(ray.m_82434_());
            }
            boolean fakePlayer = player instanceof FakePlayer;
            if (!valueSettingsBehaviour.testHit(ray.m_82450_()) && !fakePlayer) continue;
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            if (!valueSettingsBehaviour.acceptsValueSettings() || fakePlayer) {
                valueSettingsBehaviour.onShortInteract(player, hand, ray.m_82434_());
                return;
            }
            if (event.getSide() == LogicalSide.CLIENT) {
                BehaviourType<?> type = behaviour.getType();
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateClient.VALUE_SETTINGS_HANDLER.startInteractionWith(pos, type, hand, ray.m_82434_()));
            }
            return;
        }
    }

    public static boolean canInteract(Player player) {
        return player != null && !player.m_5833_() && !player.m_6144_();
    }
}

