/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;

public class SceneBuildingUtil {
    public final SelectionUtil select;
    public final VectorUtil vector;
    public final PositionUtil grid;
    private final BoundingBox sceneBounds;

    SceneBuildingUtil(BoundingBox sceneBounds) {
        this.sceneBounds = sceneBounds;
        this.select = new SelectionUtil();
        this.vector = new VectorUtil();
        this.grid = new PositionUtil();
    }

    public class SelectionUtil {
        public Selection everywhere() {
            return Selection.of(SceneBuildingUtil.this.sceneBounds);
        }

        public Selection position(int x, int y, int z) {
            return this.position(SceneBuildingUtil.this.grid.at(x, y, z));
        }

        public Selection position(BlockPos pos) {
            return this.cuboid(pos, (Vec3i)BlockPos.f_121853_);
        }

        public Selection fromTo(int x, int y, int z, int x2, int y2, int z2) {
            return this.fromTo(new BlockPos(x, y, z), new BlockPos(x2, y2, z2));
        }

        public Selection fromTo(BlockPos pos1, BlockPos pos2) {
            return this.cuboid(pos1, (Vec3i)pos2.m_121996_((Vec3i)pos1));
        }

        public Selection column(int x, int z) {
            return this.cuboid(new BlockPos(x, 1, z), new Vec3i(0, SceneBuildingUtil.this.sceneBounds.m_71057_(), 0));
        }

        public Selection layer(int y) {
            return this.layers(y, 1);
        }

        public Selection layersFrom(int y) {
            return this.layers(y, SceneBuildingUtil.this.sceneBounds.m_71057_() - y);
        }

        public Selection layers(int y, int height) {
            return this.cuboid(new BlockPos(0, y, 0), new Vec3i(SceneBuildingUtil.this.sceneBounds.m_71056_() - 1, Math.min(SceneBuildingUtil.this.sceneBounds.m_71057_() - y, height) - 1, SceneBuildingUtil.this.sceneBounds.m_71058_() - 1));
        }

        public Selection cuboid(BlockPos origin, Vec3i size) {
            return Selection.of(BoundingBox.m_162375_((Vec3i)origin, (Vec3i)origin.m_121955_(size)));
        }
    }

    public class VectorUtil {
        public Vec3 centerOf(int x, int y, int z) {
            return this.centerOf(SceneBuildingUtil.this.grid.at(x, y, z));
        }

        public Vec3 centerOf(BlockPos pos) {
            return VecHelper.getCenterOf((Vec3i)pos);
        }

        public Vec3 topOf(int x, int y, int z) {
            return this.blockSurface(SceneBuildingUtil.this.grid.at(x, y, z), Direction.UP);
        }

        public Vec3 topOf(BlockPos pos) {
            return this.blockSurface(pos, Direction.UP);
        }

        public Vec3 blockSurface(BlockPos pos, Direction face) {
            return this.blockSurface(pos, face, 0.0f);
        }

        public Vec3 blockSurface(BlockPos pos, Direction face, float margin) {
            return this.centerOf(pos).m_82549_(Vec3.m_82528_((Vec3i)face.m_122436_()).m_82490_((double)(0.5f + margin)));
        }

        public Vec3 of(double x, double y, double z) {
            return new Vec3(x, y, z);
        }
    }

    public class PositionUtil {
        public BlockPos at(int x, int y, int z) {
            return new BlockPos(x, y, z);
        }

        public BlockPos zero() {
            return this.at(0, 0, 0);
        }
    }
}

