/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.minecart;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.minecart.CouplingHandler;
import com.simibubi.create.content.contraptions.minecart.capability.MinecartController;
import com.simibubi.create.content.kinetics.KineticDebugger;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CouplingRenderer {
    public static void renderAll(PoseStack ms, MultiBufferSource buffer, Vec3 camera) {
        CouplingHandler.forEachLoadedCoupling((Level)Minecraft.m_91087_().f_91073_, c -> {
            if (((MinecartController)c.getFirst()).hasContraptionCoupling(true)) {
                return;
            }
            CouplingRenderer.renderCoupling(ms, buffer, camera, c.map(MinecartController::cart));
        });
    }

    public static void tickDebugModeRenders() {
        if (KineticDebugger.isActive()) {
            CouplingHandler.forEachLoadedCoupling((Level)Minecraft.m_91087_().f_91073_, CouplingRenderer::doDebugRender);
        }
    }

    public static void renderCoupling(PoseStack ms, MultiBufferSource buffer, Vec3 camera, Couple<AbstractMinecart> carts) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (carts.getFirst() == null || carts.getSecond() == null) {
            return;
        }
        Couple<Integer> lightValues = carts.map(c -> LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)BlockPos.m_274446_((Position)c.m_20191_().m_82399_())));
        Vec3 center = ((AbstractMinecart)carts.getFirst()).m_20182_().m_82549_(((AbstractMinecart)carts.getSecond()).m_20182_()).m_82490_(0.5);
        Couple<CartEndpoint> transforms = carts.map(c -> CouplingRenderer.getSuitableCartEndpoint(c, center));
        BlockState renderState = Blocks.f_50016_.m_49966_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        SuperByteBuffer attachment = CachedBufferer.partial(AllPartialModels.COUPLING_ATTACHMENT, renderState);
        SuperByteBuffer ring = CachedBufferer.partial(AllPartialModels.COUPLING_RING, renderState);
        SuperByteBuffer connector = CachedBufferer.partial(AllPartialModels.COUPLING_CONNECTOR, renderState);
        Vec3 zero = Vec3.f_82478_;
        Vec3 firstEndpoint = ((CartEndpoint)transforms.getFirst()).apply(zero);
        Vec3 secondEndpoint = ((CartEndpoint)transforms.getSecond()).apply(zero);
        Vec3 endPointDiff = secondEndpoint.m_82546_(firstEndpoint);
        double connectorYaw = -Math.atan2(endPointDiff.f_82481_, endPointDiff.f_82479_) * 180.0 / Math.PI;
        double connectorPitch = Math.atan2(endPointDiff.f_82480_, endPointDiff.m_82542_(1.0, 0.0, 1.0).m_82553_()) * 180.0 / Math.PI;
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        carts.forEachWithContext((cart, isFirst) -> {
            CartEndpoint cartTransform = (CartEndpoint)transforms.get((boolean)isFirst);
            ms.m_85836_();
            cartTransform.apply(ms, camera);
            attachment.light((Integer)lightValues.get((boolean)isFirst)).renderInto(ms, builder);
            msr.rotateY(connectorYaw - (double)cartTransform.yaw);
            ring.light((Integer)lightValues.get((boolean)isFirst)).renderInto(ms, builder);
            ms.m_85849_();
        });
        int l1 = (Integer)lightValues.getFirst();
        int l2 = (Integer)lightValues.getSecond();
        int meanBlockLight = ((l1 >> 4 & 0xF) + (l2 >> 4 & 0xF)) / 2;
        int meanSkyLight = ((l1 >> 20 & 0xF) + (l2 >> 20 & 0xF)) / 2;
        ms.m_85836_();
        ((TransformStack)((TransformStack)msr.translate(firstEndpoint.m_82546_(camera))).rotateY(connectorYaw)).rotateZ(connectorPitch);
        ms.m_85841_((float)endPointDiff.m_82553_(), 1.0f, 1.0f);
        connector.light(meanSkyLight << 20 | meanBlockLight << 4).renderInto(ms, builder);
        ms.m_85849_();
    }

    private static CartEndpoint getSuitableCartEndpoint(AbstractMinecart cart, Vec3 centerOfCoupling) {
        boolean isBackFaceCloser;
        long i = (long)cart.m_19879_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        double x = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        double y = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f + 0.375f;
        double z = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float pt = AnimationTickHolder.getPartialTicks();
        double xIn = Mth.m_14139_((double)pt, (double)cart.f_19790_, (double)cart.m_20185_());
        double yIn = Mth.m_14139_((double)pt, (double)cart.f_19791_, (double)cart.m_20186_());
        double zIn = Mth.m_14139_((double)pt, (double)cart.f_19792_, (double)cart.m_20189_());
        float yaw = Mth.m_14179_((float)pt, (float)cart.f_19859_, (float)cart.m_146908_());
        float pitch = Mth.m_14179_((float)pt, (float)cart.f_19860_, (float)cart.m_146909_());
        float roll = (float)cart.m_38176_() - pt;
        float rollAmplifier = cart.m_38169_() - pt;
        if (rollAmplifier < 0.0f) {
            rollAmplifier = 0.0f;
        }
        roll = roll > 0.0f ? Mth.m_14031_((float)roll) * roll * rollAmplifier / 10.0f * (float)cart.m_38177_() : 0.0f;
        Vec3 positionVec = new Vec3(xIn, yIn, zIn);
        Vec3 frontVec = positionVec.m_82549_(VecHelper.rotate(new Vec3(0.5, 0.0, 0.0), 180.0f - yaw, Direction.Axis.Y));
        Vec3 backVec = positionVec.m_82549_(VecHelper.rotate(new Vec3(-0.5, 0.0, 0.0), 180.0f - yaw, Direction.Axis.Y));
        Vec3 railVecOfPos = cart.m_38179_(xIn, yIn, zIn);
        boolean flip = false;
        if (railVecOfPos != null) {
            frontVec = cart.m_38096_(xIn, yIn, zIn, (double)0.3f);
            backVec = cart.m_38096_(xIn, yIn, zIn, (double)-0.3f);
            if (frontVec == null) {
                frontVec = railVecOfPos;
            }
            if (backVec == null) {
                backVec = railVecOfPos;
            }
            x += railVecOfPos.f_82479_;
            y += (frontVec.f_82480_ + backVec.f_82480_) / 2.0;
            z += railVecOfPos.f_82481_;
            Vec3 endPointDiff = backVec.m_82520_(-frontVec.f_82479_, -frontVec.f_82480_, -frontVec.f_82481_);
            if (endPointDiff.m_82553_() != 0.0) {
                endPointDiff = endPointDiff.m_82541_();
                yaw = (float)(Math.atan2(endPointDiff.f_82481_, endPointDiff.f_82479_) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(endPointDiff.f_82480_) * 73.0);
            }
        } else {
            x += xIn;
            y += yIn;
            z += zIn;
        }
        float offsetMagnitude = 0.8125f;
        flip = isBackFaceCloser = frontVec.m_82557_(centerOfCoupling) > backVec.m_82557_(centerOfCoupling);
        float offset = isBackFaceCloser ? -0.8125f : 0.8125f;
        return new CartEndpoint(x, y + 0.125, z, 180.0f - yaw, -pitch, roll, offset, flip);
    }

    public static void doDebugRender(Couple<MinecartController> c) {
        boolean yOffset = true;
        MinecartController first = (MinecartController)c.getFirst();
        AbstractMinecart mainCart = first.cart();
        Vec3 mainCenter = mainCart.m_20182_().m_82520_(0.0, (double)yOffset, 0.0);
        Vec3 connectedCenter = ((MinecartController)c.getSecond()).cart().m_20182_().m_82520_(0.0, (double)yOffset, 0.0);
        int color = Color.mixColors(11268329, 15631730, (float)Mth.m_14008_((double)(Math.abs((double)first.getCouplingLength(true) - connectedCenter.m_82554_(mainCenter)) * 8.0), (double)0.0, (double)1.0));
        CreateClient.OUTLINER.showLine("" + mainCart.m_19879_(), mainCenter, connectedCenter).colored(color).lineWidth(0.125f);
        Vec3 point = mainCart.m_20182_().m_82520_(0.0, (double)yOffset, 0.0);
        CreateClient.OUTLINER.showLine(mainCart.m_19879_() + "_dot", point, point.m_82520_(0.0, 0.0078125, 0.0)).colored(0xFFFFFF).lineWidth(0.25f);
    }

    static class CartEndpoint {
        double x;
        double y;
        double z;
        float yaw;
        float pitch;
        float roll;
        float offset;
        boolean flip;

        public CartEndpoint(double x, double y, double z, float yaw, float pitch, float roll, float offset, boolean flip) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.roll = roll;
            this.offset = offset;
            this.flip = flip;
        }

        public Vec3 apply(Vec3 vec) {
            vec = vec.m_82520_((double)this.offset, 0.0, 0.0);
            vec = VecHelper.rotate(vec, this.roll, Direction.Axis.X);
            vec = VecHelper.rotate(vec, this.pitch, Direction.Axis.Z);
            vec = VecHelper.rotate(vec, this.yaw, Direction.Axis.Y);
            return vec.m_82520_(this.x, this.y, this.z);
        }

        public void apply(PoseStack ms, Vec3 camera) {
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).translate(camera.m_82490_(-1.0).m_82520_(this.x, this.y, this.z))).rotateY((double)this.yaw)).rotateZ((double)this.pitch)).rotateX((double)this.roll)).translate((double)this.offset, 0.0, 0.0)).rotateY(this.flip ? 180.0 : 0.0);
        }
    }
}

